library(plyr)
source('slice.r')

# likelihood function, plateau shape
g <- function(x) {
  if (x < -2 | x >= 2) {
    return(0)
  } else if (x < -1) {
    return(x+2)
  } else if (x < 1) {
    return(1)
  } else {
    # 1 <= x < 2
    return(2-x)
  }
}

# log-likelihood function
Lg <- function(x) {
  return( log(g(x)) )
}


# get 10,000 samples from this distribution via slice sampler
samps <- lapply(1:5, function(n) slice(x0=0, g=Lg, ss=10000))

samp.concat <- ldply(samps, function(s) data.frame(x=s$X))
pdf('samp-hist.pdf', width=7, height=7)
hist(samp.concat$x)
dev.off()


# save output to file
filename <- 'sampler-example.RData'
save.image(filename)
