# understanding log-likelihood
set.seed(1000)
y = rbinom(100,1,.7)
y
sum(y) / length(y)

m = glm(y ~ 1, family="binomial")
summary(m)

# according to the GLM output, the log-likelihood of the model above is:
logLik(m)

# the maximum likelihood estimate (MLE) of the coefficient (in log-odds)
coef(m)

# the MLE of a function of parameters is the same as the function of the
# MLE of the parameters. so the MLE of the coef in probabilities is:
plogis(coef(m))

# the above MLE of the coef (here) is also the probability that
# the predicted outcome yhat = 1

# the likelihood of the model is 
exp(sum(log(ifelse(y == 1, plogis(coef(m)), 1-plogis(coef(m))))))

# the log-likelihood of the model is 
sum(log(ifelse(y == 1, plogis(coef(m)), 1-plogis(coef(m)))))
